<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Categories</title>
</head>
<body>
    <h1>Categories</h1>

    {{-- Flash success message --}}
    @if(session('success'))
        <div style="color: green;">
            {{ session('success') }}
        </div>
    @endif

    {{-- Validation errors --}}
    @if($errors->any())
        <div style="color: red;">
            <ul>
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- category input [save button] --}}
    <form action="{{ route('categories.store') }}" method="POST">
        @csrf
        <label for="nameCategory">Category:</label>
        <input type="text" name="nameCategory" id="nameCategory"
               value="{{ old('nameCategory') }}" required>
        <button type="submit">Save</button>
    </form>

    <hr>

    {{-- table [id] [category] [actions] --}}
    <table border="1" cellpadding="4" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>Category</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        @forelse ($categories as $category)
            <tr>
                <td>{{ $category->idCategory }}</td>
                <td>{{ $category->nameCategory }}</td>
                <td>
                    {{-- Edit link --}}
                    <a href="{{ route('categories.edit', $category->idCategory) }}">Edit</a>

                    {{-- Delete button --}}
                    <form action="{{ route('categories.destroy', $category->idCategory) }}"
                          method="POST" style="display:inline-block"
                          onsubmit="return confirm('Delete this category?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit">Delete</button>
                    </form>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="3">No categories yet.</td>
            </tr>
        @endforelse
        </tbody>
    </table>
</body>
</html>
