<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Edit Book</title>
</head>
<body>
    <h1>Edit Book</h1>

    @if($errors->any())
        <div style="color: red;">
            <ul>
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('books.update', $book->idBook) }}" method="POST">
        @csrf
        @method('PUT')

        <label for="nameBook">Book:</label>
        <input type="text" name="nameBook" id="nameBook"
               value="{{ old('nameBook', $book->nameBook) }}" required>

        <label for="idCategory">Category:</label>
        <select name="idCategory" id="idCategory" required>
            @foreach ($categories as $cat)
                <option value="{{ $cat->idCategory }}"
                    {{ old('idCategory', $book->idCategory) == $cat->idCategory ? 'selected' : '' }}>
                    {{ $cat->nameCategory }}
                </option>
            @endforeach
        </select>

        <button type="submit">Update</button>
        <a href="{{ route('books.index') }}">Back</a>
    </form>
</body>
</html>
