<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Books</title>
</head>
<body>
    <h1>Books</h1>

    
    <?php if(session('success')): ?>
        <div style="color: green;">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    
    <?php if($errors->any()): ?>
        <div style="color: red;">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($err); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    
    <form action="<?php echo e(route('books.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <label for="nameBook">Book:</label>
        <input type="text" name="nameBook" id="nameBook"
               value="<?php echo e(old('nameBook')); ?>" required>

        <label for="idCategory">Category:</label>
        <select name="idCategory" id="idCategory" required>
            <option value="">-- choose --</option>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($cat->idCategory); ?>"
                    <?php echo e(old('idCategory') == $cat->idCategory ? 'selected' : ''); ?>>
                    <?php echo e($cat->nameCategory); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <button type="submit">Save</button>
    </form>

    <hr>

    
    <label for="categoryFilter">Filter by category:</label>
    <select id="categoryFilter">
        <option value="">All categories</option>
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($cat->nameCategory); ?>"><?php echo e($cat->nameCategory); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>

    <br><br>

    
    <table id="booksTable" border="1" cellpadding="4" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>Book</th>
                <th>Category</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $books; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $book): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr data-category="<?php echo e($book->category->nameCategory ?? ''); ?>">
                <td><?php echo e($book->idBook); ?></td>
                <td><?php echo e($book->nameBook); ?></td>
                <td><?php echo e($book->category->nameCategory ?? '-'); ?></td>
                <td>
                    
                    <a href="<?php echo e(route('books.edit', $book->idBook)); ?>">Edit</a>

                    
                    <form action="<?php echo e(route('books.destroy', $book->idBook)); ?>"
                          method="POST" style="display:inline-block"
                          onsubmit="return confirm('Delete this book?');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="4">No books yet.</td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>

    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const select = document.getElementById('categoryFilter');
            const rows   = document.querySelectorAll('#booksTable tbody tr');

            select.addEventListener('change', function () {
                const selected = this.value;

                rows.forEach(function (row) {
                    const rowCategory = row.getAttribute('data-category') || '';

                    if (!selected || rowCategory === selected) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                });
            });
        });
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\advweb-prak-w9\resources\views/books.blade.php ENDPATH**/ ?>