<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Books</title>
</head>
<body>
    <h1>Books</h1>

    {{-- Flash success message --}}
    @if(session('success'))
        <div style="color: green;">
            {{ session('success') }}
        </div>
    @endif

    {{-- Validation errors --}}
    @if($errors->any())
        <div style="color: red;">
            <ul>
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- book input [save button] --}}
    <form action="{{ route('books.store') }}" method="POST">
        @csrf

        <label for="nameBook">Book:</label>
        <input type="text" name="nameBook" id="nameBook"
               value="{{ old('nameBook') }}" required>

        <label for="idCategory">Category:</label>
        <select name="idCategory" id="idCategory" required>
            <option value="">-- choose --</option>
            @foreach ($categories as $cat)
                <option value="{{ $cat->idCategory }}"
                    {{ old('idCategory') == $cat->idCategory ? 'selected' : '' }}>
                    {{ $cat->nameCategory }}
                </option>
            @endforeach
        </select>

        <button type="submit">Save</button>
    </form>

    <hr>

    {{-- FILTER: select-option per category (client-side JS) --}}
    <label for="categoryFilter">Filter by category:</label>
    <select id="categoryFilter">
        <option value="">All categories</option>
        @foreach ($categories as $cat)
            <option value="{{ $cat->nameCategory }}">{{ $cat->nameCategory }}</option>
        @endforeach
    </select>

    <br><br>

    {{-- table [id] [book] [category] [actions] --}}
    <table id="booksTable" border="1" cellpadding="4" cellspacing="0">
        <thead>
            <tr>
                <th>ID</th>
                <th>Book</th>
                <th>Category</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        @forelse ($books as $book)
            <tr data-category="{{ $book->category->nameCategory ?? '' }}">
                <td>{{ $book->idBook }}</td>
                <td>{{ $book->nameBook }}</td>
                <td>{{ $book->category->nameCategory ?? '-' }}</td>
                <td>
                    {{-- Edit link --}}
                    <a href="{{ route('books.edit', $book->idBook) }}">Edit</a>

                    {{-- Delete button --}}
                    <form action="{{ route('books.destroy', $book->idBook) }}"
                          method="POST" style="display:inline-block"
                          onsubmit="return confirm('Delete this book?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit">Delete</button>
                    </form>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="4">No books yet.</td>
            </tr>
        @endforelse
        </tbody>
    </table>

    {{-- Simple JS filter --}}
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const select = document.getElementById('categoryFilter');
            const rows   = document.querySelectorAll('#booksTable tbody tr');

            select.addEventListener('change', function () {
                const selected = this.value;

                rows.forEach(function (row) {
                    const rowCategory = row.getAttribute('data-category') || '';

                    if (!selected || rowCategory === selected) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                });
            });
        });
    </script>
</body>
</html>
