<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('book', function (Blueprint $table) {
            $table->id('idBook');
            $table->string('nameBook');
            $table->unsignedBigInteger('idCategory');
            $table->timestamps();

            // Foreign key constraint
            $table
                ->foreign('idCategory')
                ->references('idCategory')
                ->on('categories')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('book');
    }
};
