<?php

namespace App\Models;

use App\Models\Category;
use Illuminate\Database\Eloquent\Model;

class Book extends Model
{
    protected $table = 'book';  // table name (singular in migration)
    protected $primaryKey = 'idBook';  // PK from migration
    public $incrementing = true;
    protected $keyType = 'int';
    protected $fillable = ['nameBook', 'idCategory'];

    public function category()
    {
        return $this->belongsTo(Category::class, 'idCategory', 'idCategory');
    }
}
