<?php

namespace App\Http\Controllers;

use App\Models\Book;
use App\Models\Category;
use Illuminate\Http\Request;

class BookController extends Controller
{
    // Show form + table
    public function index()
    {
        $books = Book::with('category')
            ->orderBy('idBook')
            ->get();

        $categories = Category::orderBy('nameCategory')->get();

        return view('books', [
            'books' => $books,
            'categories' => $categories,
        ]);
    }

    // Save new book
    public function store(Request $request)
    {
        $request->validate([
            'nameBook' => 'required|string|max:255',
            'idCategory' => 'required|exists:categories,idCategory',
        ]);

        Book::create([
            'nameBook' => $request->nameBook,
            'idCategory' => $request->idCategory,
        ]);

        return redirect()
            ->route('books.index')
            ->with('success', 'Book added.');
    }

    // Show edit form
    public function edit(Book $book)
    {
        $categories = Category::orderBy('nameCategory')->get();

        return view('books_edit', [
            'book' => $book,
            'categories' => $categories,
        ]);
    }

    // Update existing book
    public function update(Request $request, Book $book)
    {
        $request->validate([
            'nameBook' => 'required|string|max:255',
            'idCategory' => 'required|exists:categories,idCategory',
        ]);

        $book->update([
            'nameBook' => $request->nameBook,
            'idCategory' => $request->idCategory,
        ]);

        return redirect()
            ->route('books.index')
            ->with('success', 'Book updated.');
    }

    // Delete a book
    public function destroy(Book $book)
    {
        $book->delete();

        return redirect()
            ->route('books.index')
            ->with('success', 'Book deleted.');
    }
}
